<?php
class Keyboards {
    
    public static function mainMenu($chat_id) {
        $keyboard = [
            [['text' => '💰 Deposit'], ['text' => '💸 Withdraw']],
            [['text' => '💵 Balance'], ['text' => '🎯 Referral']]
        ];

        // بررسی می‌کنیم آیا آیدی کاربر در لیست ادمین‌ها وجود دارد؟
        if (in_array($chat_id, ADMIN_IDS)) {
            $keyboard[] = [['text' => '🔐 Admin Panel']];
        }

        return json_encode([
            'keyboard' => $keyboard,
            'resize_keyboard' => true
        ]);
    }

    public static function adminMenu() {
        return json_encode([
            'keyboard' => [
                [['text' => '📊 Statistics'], ['text' => '📢 Broadcast']],
                [['text' => '⚙️ Set TRC20'], ['text' => '⚙️ Set BNB']],
                [['text' => '➕ Add Balance'], ['text' => '🔙 Back to User Mode']]
            ],
            'resize_keyboard' => true
        ]);
    }

    public static function back() {
        return json_encode([
            'keyboard' => [[['text' => '🔙 Back']]], 
            'resize_keyboard' => true
        ]);
    }

    public static function verifyHuman() {
        return json_encode([
            'keyboard' => [
                [['text' => '🧬 I am a Human'], ['text' => '🔙 Back']]
            ],
            'resize_keyboard' => true
        ]);
    }

    public static function confirmReject($tx_id) {
        return json_encode([
            'inline_keyboard' => [
                [
                    ['text' => '✅ Approve', 'callback_data' => "approve_$tx_id"],
                    ['text' => '❌ Reject', 'callback_data' => "reject_$tx_id"]
                ]
            ]
        ]);
    }
}