<?php
require_once __DIR__ . '/Database.php';
require_once __DIR__ . '/Keyboards.php';

class Bot {
    private $db;
    private $api;
    private $botUsername = "JoJoYabBot"; // نام ربات شما

    public function __construct() {
        $this->db = new Database();
        $this->api = "https://api.telegram.org/bot" . BOT_TOKEN . "/";
    }

    public function handleRequest() {
        $content = file_get_contents("php://input");
        $update = json_decode($content, true);

        if (isset($update['message'])) {
            $this->processMessage($update['message']);
        } elseif (isset($update['callback_query'])) {
            $this->processCallback($update['callback_query']);
        }
    }

    private function processMessage($message) {
        $chat_id = $message['chat']['id'];
        $text = $message['text'] ?? '';
        $first_name = $message['chat']['first_name'] ?? 'User';

        // این خط را از اینجا برمیداریم چون باید داخل دستور start مدیریت شود
        // تا بفهمیم کاربر جدید است یا نه
        // $this->db->createUser($chat_id, $first_name); 

        // دریافت اطلاعات کاربر (اگر وجود داشته باشد)
        $user = $this->db->getUser($chat_id);
        $step = $user ? $user['step'] : 'none';

        // ================= ADMIN PANEL =================
        if ($this->isAdmin($chat_id)) {
            if ($text == '🔐 Admin Panel' || $text == '/admin') {
                $this->db->setStep($chat_id, 'none');
                $this->sendMessage($chat_id, "👮‍♂️ Admin Panel:", Keyboards::adminMenu());
                return;
            }
            if ($text == '🔙 Back to User Mode') {
                $this->db->setStep($chat_id, 'none');
                $this->sendMessage($chat_id, "🏠 User Menu:", Keyboards::mainMenu($chat_id));
                return;
            }
            // --- Admin Logic ---
            if ($text == '📊 Statistics') {
                $userCount = $this->db->getUserCount();
                $totalBal = $this->formatMoney($this->db->getTotalBalance());
                $msg = "📊 **Bot Statistics**\n\n👤 Total Users: `$userCount`\n💰 Total User Balances: `$$totalBal`";
                $this->sendMessage($chat_id, $msg, null, 'Markdown');
                return;
            }
             if ($text == '📢 Broadcast') {
                $this->db->setStep($chat_id, 'broadcast');
                $this->sendMessage($chat_id, "👇 Send message to broadcast:", Keyboards::back());
                return;
            }
             if ($text == '⚙️ Set TRC20') {
                $this->db->setStep($chat_id, 'set_trc20');
                $this->sendMessage($chat_id, "👇 Send new TRC20 address:", Keyboards::back());
                return;
            }
             if ($text == '⚙️ Set BNB') {
                $this->db->setStep($chat_id, 'set_bnb');
                $this->sendMessage($chat_id, "👇 Send new BNB address:", Keyboards::back());
                return;
            }
            if ($text == '➕ Add Balance') {
                $this->db->setStep($chat_id, 'add_balance_id');
                $this->sendMessage($chat_id, "👇 Send User **Chat ID**:", Keyboards::back());
                return;
            }

            // --- Admin Steps ---
            if ($step == 'set_trc20') {
                $this->db->updateSetting('trc20', $text);
                $this->db->setStep($chat_id, 'none');
                $this->sendMessage($chat_id, "✅ Updated!", Keyboards::adminMenu());
                return;
            }
            if ($step == 'set_bnb') {
                $this->db->updateSetting('bnb', $text);
                $this->db->setStep($chat_id, 'none');
                $this->sendMessage($chat_id, "✅ Updated!", Keyboards::adminMenu());
                return;
            }
            if ($step == 'broadcast') {
                $users = $this->db->getAllUsers();
                foreach ($users as $u) $this->sendMessage($u['chat_id'], $text);
                $this->db->setStep($chat_id, 'none');
                $this->sendMessage($chat_id, "✅ Broadcast sent.", Keyboards::adminMenu());
                return;
            }
            if ($step == 'add_balance_id') {
                if (is_numeric($text)) {
                    $this->db->updateSetting("admin_temp_uid_$chat_id", $text);
                    $this->db->setStep($chat_id, 'add_balance_amount');
                    $this->sendMessage($chat_id, "👇 Enter amount:", Keyboards::back());
                } else {
                    $this->sendMessage($chat_id, "❌ Invalid ID.");
                }
                return;
            }
            if ($step == 'add_balance_amount') {
                if (is_numeric($text)) {
                    $target_id = $this->db->getSetting("admin_temp_uid_$chat_id");
                    if($this->db->addBalance($target_id, $text)){
                        $this->db->setStep($chat_id, 'none');
                        $formatted = $this->formatMoney($text);
                        $this->sendMessage($chat_id, "✅ $$formatted Added to `$target_id`", Keyboards::adminMenu(), 'Markdown');
                        $this->sendMessage($target_id, "💰 Account credited: $$formatted USDT");
                    } else {
                        $this->sendMessage($chat_id, "❌ User not found.", Keyboards::adminMenu());
                    }
                } else {
                    $this->sendMessage($chat_id, "❌ Invalid amount.");
                }
                return;
            }
        }
        // ================= END ADMIN =================

        // دکمه بازگشت عمومی
        if ($text == '🔙 Back') {
            // اگر کاربر وجود ندارد بسازیمش (محض احتیاط)
            $this->db->createUser($chat_id, $first_name);
            $this->db->setStep($chat_id, 'none');
            $this->sendMessage($chat_id, "🏠 Main Menu:", Keyboards::mainMenu($chat_id));
            return;
        }

        // ============ START COMMAND (REFERRAL LOGIC) ============
        if (strpos($text, '/start') === 0) {
            $referrer_id = null;
            $parts = explode(' ', $text);
            
            // چک کردن اینکه آیا لینک رفرال معتبر است
            if (isset($parts[1]) && is_numeric($parts[1]) && $parts[1] != $chat_id) {
                $referrer_id = $parts[1];
            }

            // تلاش برای ساخت کاربر. این تابع اگر کاربر جدید باشد True برمیگرداند
            $isNewUser = $this->db->createUser($chat_id, $first_name, $referrer_id);
            
            // ریست کردن استپ
            $this->db->setStep($chat_id, 'none');
            
            // اگر کاربر جدید بود و معرف داشت
            if ($isNewUser && $referrer_id) {
                // دریافت تعداد رفرال‌های جدید معرف
                $refCount = $this->db->getReferralCount($referrer_id);
                
                // ارسال پیام به معرف
                $this->sendMessage($referrer_id, "🥳 <b>New Referral Joined!</b>\n\nUser: $first_name\n👥 Your Total Referrals: $refCount");
                
                // در اینجا میتوانید پاداش هم بدهید (اختیاری)
                // $this->db->addBalance($referrer_id, 10); 
                // $this->sendMessage($referrer_id, "💰 You received $10 bonus!");
            }
            
            $welcomeText = "Welcome to Alpha Invest Official! \nAchieve your financial goals.";
            $this->sendMessage($chat_id, $welcomeText, Keyboards::mainMenu($chat_id));
            return;
        }

        // اگر کاربر در دیتابیس نیست، همینجا بسازیمش (برای کاربرانی که استارت نزدند و دکمه زدند)
        if (!$user) {
            $this->db->createUser($chat_id, $first_name);
            $user = $this->db->getUser($chat_id);
        }

        switch ($text) {
            case '💰 Deposit':
                $trc20 = $this->db->getSetting('trc20');
                $bnb = $this->db->getSetting('bnb');
                $msg = "💰Minimum Deposit $100.00\n\nSend USDT to This Wallet Address👇\n\n🔹Tron (TRC20)\n<code>$trc20</code>\n\n🔹BNB (BEP20)\n<code>$bnb</code>";
                $this->sendMessage($chat_id, $msg);
                break;

            case '💸 Withdraw':
                $this->db->setStep($chat_id, 'verify_human_step');
                $this->sendMessage($chat_id, "Verify You’re Not a Bot 🤖", Keyboards::verifyHuman());
                break;

            case '💵 Balance':
                $user = $this->db->getUser($chat_id); // رفرش کردن اطلاعات کاربر
                $balance = $this->formatMoney($user['balance']);
                $totalWithdraw = $this->db->getTotalWithdrawals($chat_id);
                $withdrawsFormatted = $this->formatMoney($totalWithdraw);

                $msg = "🔹 Your Balance : $$balance USDT\n" . 
                       "⏏️ Withdraws : $$withdrawsFormatted";
                
                $this->sendMessage($chat_id, $msg);
                break;
                
            case '🎯 Referral':
                // دریافت دقیق تعداد از دیتابیس
                $count = $this->db->getReferralCount($chat_id);
                $link = "https://t.me/" . $this->botUsername . "?start=" . $chat_id;
                
                $msg = "🎯 Invite & Earn\n" .
                       "💵 Get 50% of Referrals Profit\n" . 
                       "🚀 Start Today Grow Your Income\n\n" . 
                       "👥 Your Referrals: <b>$count</b>\n" . 
                       "🔗 Link: $link";
                $this->sendMessage($chat_id, $msg);
                break;

            default:
                 // --- LOGIC BRDASHT ---
                 if ($step == 'verify_human_step') {
                     if ($text == '🧬 I am a Human') {
                         $this->db->setStep($chat_id, 'withdraw_wallet');
                         $this->sendMessage($chat_id, "✅ Verified!\n\n👇 Enter Your USDT TRC20 Address:", Keyboards::back());
                     } else {
                         $this->sendMessage($chat_id, "Please verify first.", Keyboards::verifyHuman());
                     }
                 }
                 else if ($step == 'withdraw_wallet') {
                     $this->db->updateSetting("temp_wallet_$chat_id", $text);
                     $this->db->setStep($chat_id, 'withdraw_amount');
                     $balance = $this->formatMoney($user['balance']);
                     $this->sendMessage($chat_id, "💳 Your Balance: $$balance USDT\n\n👇 Enter Amount to Withdraw (Min: $100):", Keyboards::back());
                 }
                 else if ($step == 'withdraw_amount') {
                     if (!is_numeric($text)) {
                         $this->sendMessage($chat_id, "❌ Please enter a valid number.");
                         return;
                     }
                     $amount = floatval($text);
                     if ($amount < 100) {
                         $this->sendMessage($chat_id, "❌ Minimum withdrawal is $100.");
                         return;
                     }
                     if ($amount > $user['balance']) {
                         $this->sendMessage($chat_id, "❌ Insufficient balance!");
                         return;
                     }
                     
                     $wallet = $this->db->getSetting("temp_wallet_$chat_id");
                     $this->db->deductBalance($chat_id, $amount);
                     $tx_id = $this->db->createWithdrawRequest($chat_id, $amount, $wallet);
                     
                     $this->db->setStep($chat_id, 'none');
                     $this->sendMessage($chat_id, "✅ Withdrawal Request Sent!\nWait for admin approval.", Keyboards::mainMenu($chat_id));
                     
                     $formattedAmount = $this->formatMoney($amount);
                     $adminMsg = "⚠️ **New Withdraw Request**\n\n🆔 TxID: `$tx_id`\n👤 User: `$chat_id`\n💰 Amount: `$$formattedAmount`\n🏦 Wallet: `$wallet`";
                     $this->sendToAllAdmins($adminMsg, Keyboards::confirmReject($tx_id));
                 }
                 else {
                    $this->sendMessage($chat_id, "Please select an option.", Keyboards::mainMenu($chat_id));
                 }
                break;
        }
    }

    private function processCallback($callback) {
        $chat_id = $callback['message']['chat']['id'];
        $data = $callback['data'];
        $message_id = $callback['message']['message_id'];

        if (!$this->isAdmin($chat_id)) return;

        if (strpos($data, 'approve_') === 0) {
            $tx_id = str_replace('approve_', '', $data);
            $tx = $this->db->getTransaction($tx_id);
            if ($tx && $tx['status'] == 'pending') {
                $this->db->updateTransactionStatus($tx_id, 'approved');
                $this->editMessageText($chat_id, $message_id, "✅ Request #$tx_id Approved by Admin ($chat_id)!");
                $this->sendMessage($tx['chat_id'], "✅ Your withdrawal of $" . $this->formatMoney($tx['amount']) . " has been approved and sent!");
            } else {
                 $this->sendMessage($chat_id, "❌ Invalid or already processed.");
            }
        }
        
        if (strpos($data, 'reject_') === 0) {
            $tx_id = str_replace('reject_', '', $data);
            $tx = $this->db->getTransaction($tx_id);
            if ($tx && $tx['status'] == 'pending') {
                $this->db->updateTransactionStatus($tx_id, 'rejected');
                $this->db->addBalance($tx['chat_id'], $tx['amount']);
                $this->editMessageText($chat_id, $message_id, "❌ Request #$tx_id Rejected by Admin ($chat_id).");
                $this->sendMessage($tx['chat_id'], "❌ Your withdrawal of $" . $this->formatMoney($tx['amount']) . " was rejected.");
            }
        }
    }

    private function isAdmin($chat_id) {
        if (!defined('ADMIN_IDS')) return $chat_id == ADMIN_ID; // Fallback for old config
        return in_array($chat_id, ADMIN_IDS);
    }

    private function sendToAllAdmins($text, $keyboard = null) {
        if (!defined('ADMIN_IDS')) { // Fallback
             $this->sendMessage(ADMIN_ID, $text, $keyboard, 'Markdown');
             return;
        }
        foreach (ADMIN_IDS as $admin_id) {
            $this->sendMessage($admin_id, $text, $keyboard, 'Markdown');
        }
    }

    private function formatMoney($number) {
        if (floor($number) == $number) {
            return number_format($number, 0);
        }
        return number_format($number, 2);
    }

    private function sendMessage($chat_id, $text, $keyboard = null, $parse_mode = 'HTML') {
        $data = [
            'chat_id' => $chat_id,
            'text' => $text,
            'parse_mode' => $parse_mode
        ];
        if ($keyboard) {
            $data['reply_markup'] = $keyboard;
        }
        $this->sendRequest('sendMessage', $data);
    }
    
    private function editMessageText($chat_id, $message_id, $text) {
        $data = [
            'chat_id' => $chat_id,
            'message_id' => $message_id,
            'text' => $text,
            'parse_mode' => 'HTML'
        ];
        $this->sendRequest('editMessageText', $data);
    }

    private function sendRequest($method, $data) {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $this->api . $method);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $result = curl_exec($ch);
        curl_close($ch);
        return $result;
    }
}